// offload-context.js
// 依赖: common.js, message-utils.js

function renderOffloadContext(data, tokenRanking) {
    const offloadContext = getOffloadContext(data);

    const container = document.getElementById('offloadMessagesContainer');
    const overviewDiv = document.getElementById('offloadOverview');
    
    if (!offloadContext || Object.keys(offloadContext).length === 0) {
        container.innerHTML = 
            '<div class="empty-state"><div class="empty-state-icon">⚠️</div><div>未找到offloadContext数据</div></div>';
        if (overviewDiv) {
            overviewDiv.style.display = 'none';
        }
        return;
    }

    // 计算统计数据
    const blockCount = Object.keys(offloadContext).length;
    let totalMessages = 0;
    let maxMessages = 0;
    let minMessages = Infinity;
    
    // 使用和渲染部分完全相同的逻辑来统计
    Object.entries(offloadContext).forEach(([uuid, messages]) => {
        // 检查messages的类型，使用和渲染部分相同的逻辑
        if (Array.isArray(messages)) {
            const messageCount = messages.length;
            totalMessages += messageCount;
            maxMessages = Math.max(maxMessages, messageCount);
            minMessages = Math.min(minMessages, messageCount);
        } else {
            // 调试：如果不是数组，输出详细信息
            console.log('offloadContext项不是数组:', {
                uuid: uuid,
                type: typeof messages,
                isArray: Array.isArray(messages),
                value: messages
            });
        }
    });
    
    // 调试：输出统计结果
    console.log('卸载上下文统计:', {
        blockCount: blockCount,
        totalMessages: totalMessages,
        maxMessages: maxMessages,
        minMessages: minMessages === Infinity ? 0 : minMessages,
        offloadContextKeys: Object.keys(offloadContext),
        offloadContextSample: Object.entries(offloadContext).slice(0, 2).map(([k, v]) => ({
            key: k,
            isArray: Array.isArray(v),
            length: Array.isArray(v) ? v.length : 'N/A',
            type: typeof v
        }))
    });
    
    // 从原始内存中统计context_reload方法的执行次数
    let reloadCount = 0;
    let originalMemory = [];
    if (data.agent && data.agent.memory && data.agent.memory.originalMemoryStorage) {
        originalMemory = data.agent.memory.originalMemoryStorage;
    } else if (data.originalMemoryStorage) {
        originalMemory = data.originalMemoryStorage;
    }
    
    if (originalMemory && Array.isArray(originalMemory)) {
        originalMemory.forEach(msg => {
            if (msg.content && Array.isArray(msg.content)) {
                msg.content.forEach(item => {
                    // 检查是否是tool_use类型且name为context_reload
                    if (item.type === 'tool_use' && item.name === 'context_reload') {
                        reloadCount++;
                    }
                });
            }
        });
    }
    
    // 显示总览
    if (overviewDiv && blockCount > 0) {
        overviewDiv.style.display = 'block';
        document.getElementById('offloadBlockCount').textContent = blockCount.toLocaleString();
        document.getElementById('offloadTotalMessages').textContent = totalMessages.toLocaleString();
        document.getElementById('offloadMaxMessages').textContent = maxMessages.toLocaleString();
        document.getElementById('offloadMinMessages').textContent = (minMessages === Infinity ? 0 : minMessages).toLocaleString();
        document.getElementById('offloadReloadCount').textContent = reloadCount.toLocaleString();
    } else if (overviewDiv) {
        overviewDiv.style.display = 'none';
    }

    container.innerHTML = '';
    
    // 按UUID分组显示
    Object.entries(offloadContext).forEach(([uuid, messages], blockIndex) => {
        // 创建卸载块容器
        const blockDiv = document.createElement('div');
        blockDiv.style.marginBottom = '24px';
        blockDiv.style.padding = '16px';
        blockDiv.style.background = '#f8f9fa';
        blockDiv.style.border = '2px solid #fd7e14';
        blockDiv.style.borderRadius = '8px';
        
        // 块标题
        const blockHeader = document.createElement('div');
        blockHeader.style.fontSize = '14px';
        blockHeader.style.fontWeight = 'bold';
        blockHeader.style.color = '#fd7e14';
        blockHeader.style.marginBottom = '12px';
        blockHeader.style.paddingBottom = '8px';
        blockHeader.style.borderBottom = '1px solid #fd7e14';
        blockHeader.innerHTML = `卸载块 #${blockIndex + 1} | UUID: <code style="font-size: 12px; color: #666;">${uuid}</code> | 消息数: ${Array.isArray(messages) ? messages.length : 0}`;
        blockDiv.appendChild(blockHeader);
        
        // 消息列表
        if (Array.isArray(messages)) {
            messages.forEach((msg, msgIndex) => {
                const messageDiv = createMessageElement(msg, msgIndex, data, tokenRanking);
                blockDiv.appendChild(messageDiv);
            });
        } else {
            const errorDiv = document.createElement('div');
            errorDiv.className = 'empty-state';
            errorDiv.innerHTML = '<div>无效的消息数据</div>';
            blockDiv.appendChild(errorDiv);
        }
        
        container.appendChild(blockDiv);
    });
}

